% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/riskscore_fct.R
\name{riskscore_fct}
\alias{riskscore_fct}
\title{Main function of SurvRank.}
\usage{
riskscore_fct(cv.ob, data, th = 0.5, surv.tab = c(0.5), f = NA,
  fix.var = NA, list.t = "weighted", ncl = 1, plt = F, ...)
}
\arguments{
\item{cv.ob}{output of the \code{\link{CVrankSurv_fct}}}

\item{data}{same list used as input in \code{\link{CVrankSurv_fct}}}

\item{th}{Defaults to 0.5. Threshold of used features. th=0.5 majority vote approach}

\item{surv.tab}{Defaults to c(0.5). Calculates for selected features survival curves. \code{surv.tab} determines quantiles of predictions.}

\item{f}{Defaults to NA. ranking approach function. One of \code{fsSurvRankConc}, \code{fsSurvRankGlmnet}, \code{fsSurvRankRf}, \code{fsSurvRankBoost}, \code{fsSurvRankCox}, \code{fsSurvRankRandCox}, \code{fsSurvRankRpart}, \code{fsSurvRankWang} or NA, no calculation}

\item{fix.var}{Defauts to NA. not NA, fixed number of features is calculated}

\item{list.t}{Defauls to "weighted". Which toplist should be chosen? Possible choices are "weighted", "unweighted", "rank", "top1se","cluster" or "final"}

\item{ncl}{Defaults to 1. Number of clusters for parallel execution.}

\item{plt}{Default=F. Should plot of survival curves be generated?}

\item{...}{arguments that can be passed to underlying functions, not used now}
}
\value{
Output of the \code{riskscore_fct}, basically a list containing the following elements
\item{\code{selnames}}{toplist of features that have been chosen}
\item{\code{fixR}}{Matrix of survival AUCs with fixed number of features, but not fixed features!! (could also be calculated before)}
\item{\code{model}}{cox model output for selected features, according to \code{list.t}}
\item{\code{aic}}{AIC criterion of cox model}
\item{\code{sum.model}}{summary object of the fitted cox model}
\item{\code{concordance}}{concordance measure of fitted cox model}
\item{\code{sfit}}{survfit object of the cox model)}
\item{\code{pfit}}{predictions of the cox model (fitted values)}
\item{\code{sfit.tab}}{survfit object according to \code{surv.tab} seperation}
\item{\code{sfit.cox}}{Cox model on the groups generated by \code{surv.tab}}
\item{\code{sfit.diff}}{surfdiff: Tests if there is a difference between two or more survival curves using the G-rho family of tests, or for a single curve against a known alternative}
Additionally two plots are generated: if \code{f} is not \code{NA}, a boxplot of the survival AUCs, averaged for cross-validation iterations. The second plot shows the resulting survival curves according to \code{surv.tab}.
}
\description{
Main input function for SurvRank.
}
\details{
details to follow
}
\examples{
## Simulating a survival data set
N=100; p=10; n=3
x=data.frame(matrix(rnorm(N*p),nrow=N,p))
beta=rnorm(n)
mx=matrix(rnorm(N*n),N,n)
fx=mx[,seq(n)]\%*\%beta/3
hx=exp(fx)
ty=rexp(N,hx)
tcens=1-rbinom(n=N,prob=.3,size=1)
y=Surv(ty,tcens)
data=list()
data$x<-x; data$y<-y
out<-CVrankSurv_fct(data,2,3,3,fs.method="cox.rank")
## Using the weighted toplist
risk<-riskscore_fct(out,data,list.t="weighted")
## Selected names
risk$selnames
}
\keyword{SurvRank}

