% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_distance_tree_matrix.R
\name{predict_distance_tree_matrix}
\alias{predict_distance_tree_matrix}
\title{Predict Distances Between Samples Based on a Survival Tree Fit (Data Supplied as Matrices)}
\usage{
predict_distance_tree_matrix(
  survival_tree,
  matrix_numeric,
  matrix_factor,
  missing = "omit"
)
}
\arguments{
\item{survival_tree}{a fitted survival tree}

\item{matrix_numeric}{numeric predictors, a numeric matrix. 
\code{matrix_numeric[i,j]} is the jth numeric predictor of the ith sample.
The best practice is to have the same column names in the training and testing dataset.}

\item{matrix_factor}{factor predictors, a character matrix. 
\code{matrix_factor[i,j]} is the jth predictor of the ith sample.
The best practice is to have the same column names in the training and testing dataset.}

\item{missing}{a character value that specifies the handling of missing data. 
If \code{missing=="omit"}, samples with missing values in the splitting variables will be discarded.
If \code{missing=="majority"}, samples with missing values in the splitting variables will be assigned to the majority node.
If \code{missing=="weighted"}, samples with missing values in the splitting variables will be weighted by the weights of branch nodes.
The best practice is to use the same method as the trained random tree.}
}
\value{
A list.
\code{node_distance} gives the distance matrix between nodes.
\code{ind_distance} gives the distance matrix between samples.
\code{ind_weights} gives the weights of samples in each node.
}
\description{
The function 
\code{predict_distance_tree_matrix} predicts distances between samples based on a survival tree fit.
}
\details{
Predict Distances Between Samples Based on a Survival Tree Fit (Data Supplied as Matrices)
(Works for raw matrices)
}
\examples{
library(survival)
a_survival_tree<-
  survival_tree_matrix(
    time=lung$time,
    event=lung$status==2,
    matrix_numeric=data.matrix(lung[,c(4,6:9),drop=FALSE]),
    matrix_factor=data.matrix(lung[,5,drop=FALSE]))
a_distance<-
  predict_distance_tree_matrix(
    a_survival_tree,
    matrix_numeric=data.matrix(lung[,c(4,6:9),drop=FALSE]),
    matrix_factor=data.matrix(lung[,5,drop=FALSE]))
}
