% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_TAAG.R
\name{pred.TAAG}
\alias{pred.TAAG}
\title{Prediction from the TAAG Process}
\usage{
pred.TAAG(object, newX, predict.CI = FALSE,  zalpha = 1.96)
}
\arguments{

\item{object}{object of class inheriting from "TAAG".}

\item{newX}{matrix of new values of x at which predictions are needed.}

\item{predict.CI}{logical value indicating if the confidence interval at each prediction point is required.}

\item{zalpha}{normal critical value for the confidence interval. Default is 1.96 for 95 \% confidence intervals. The zalpha works only when predict.CI is TRUE.}
}
\description{
This function provides predictions from a TAAG process.
}
\value{
The function returns predictions at newX and the confidence intervals (if predict.CI is TRUE).
If predict.CI is TRUE, the values returned from the function is a list containing:
\item{Prediction}{the prediction at newX.}
\item{ConfidenceLB}{the lower bound of the prediction confidence interval at newX.(Note that the default is 95 \%.)}
\item{ConfidenceUB}{the upper bound of the prediction confidence interval at newX.}

}
\references{
Lin, L.-H. and Joseph,  V. R. (2019+) "Transformation and Additivity in Gaussian Processes", \emph{Technometrics, to appear}.  DOI:10.1080/00401706.2019.1665592.
}
\seealso{
  \code{\link{TAAG}} for the estimates of the parameters in the TAAG.
}
\examples{
n <- 20
p <- 2
library(randtoolbox)
X <-   sobol(n, dim = p, init = TRUE, scrambling = 2, seed = 20, normal = FALSE)
y <- exp(2*sin(0.5*pi*X[,1]) + 0.5*cos(2.5*pi*X[,2]))
ini.TAG <- initial.TAG(y, X)
par.TAG <- TAG(ini.TAG)
N <- 1000 # size of testing samples
X.test <-  sobol(N, dim = p, init = TRUE, scrambling = 2, seed = 5, normal = FALSE)
ytrue  <- exp(2*sin(0.5*pi*X.test[,1]) + 0.5*cos(2.5*pi*X.test[,2]))
pre.TAG <- pred.TAG(par.TAG, X.test)
library(DiceKriging)
set.seed(2)
temp.m <- km(formula=~1, design=X, response=par.TAG$ty,
   covtype="gauss",nugget = (10^-15), multistart = 4)
nu.est <- sqrt(2*(coef(temp.m)$range^2))
par.TAAG <- TAAG(par.TAG, nu.est)
pre.TAAG <- pred.TAAG(par.TAAG, X.test)
mean((pre.TAAG$Prediction-ytrue)^2)
}
\keyword{TAAG}
\keyword{Predictions}
