% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCGAretr_scr.R
\name{get_ext_mutation}
\alias{get_ext_mutation}
\title{Retrieve Extended Information About DNA Mutations from TCGA}
\usage{
get_ext_mutation(case_id = NULL, gprofile_id = NULL, glist = NULL)
}
\arguments{
\item{case_id}{string corresponding to the Identifier of the case_list of interest}

\item{gprofile_id}{string corresponding to the Identifier of the Genetic Profile of Interest}

\item{glist}{character vector including Gene Identifiers (ENTREZID or OFFICIAL_SYMBOL)}
}
\value{
data Frame inluding one row per mutation
}
\description{
Query TCGA for Data about DNA Sequence Variations (Mutations) identified by exome sequencing projects. 
The function will retrieve an extensive set of information for each mutation that was identified in 
the set of cases of interest. The function can only handle a limited number of query genes. 
For larger queries, use the fetch_all_tcgadata() function.
}
\examples{
tp53_mutats <- get_ext_mutation("blca_tcga_all", "blca_tcga_mutations", "TP53")
if(ncol(tp53_mutats) >= 6 & nrow(tp53_mutats) >= 10){
  tp53_mutats[1:10,1:6]
}

}
\references{
\itemize{
  \item \url{http://www.biotechworld.it/bioinf/2016/07/11/tcga-data-via-tcgaretriever/}
  \item \url{https://www.data-pulse.com/dev_site/TCGAretriever/}
}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
