% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{HubbertWindFieldPi}
\alias{HubbertWindFieldPi}
\title{Hubbert Wind Field Time Series}
\usage{
HubbertWindFieldPi(f, rMax, vFm, thetaFm, Rlam, V)
}
\arguments{
\item{f}{single coriolis parameter at the centre of TC in hz}

\item{rMax}{radius of maximum winds in km}

\item{vFm}{input forward velocity of TC}

\item{thetaFm}{input forward direction of TC}

\item{Rlam}{two columns for distances and direction from grid points to TC centre in km}

\item{V}{velocity profile}
}
\value{
array with two columns for zonal and meridional wind speed vector-components.
//@example HubbertWindFieldPi(-1e-4,20,2,10,rbind(c(50,35),c(45,40)),c(20,20))
}
\description{
Time series vortex Wind, wind vectors. Hubbert, G.D., G.J.Holland, L.M.Leslie and M.J.Manton, 1991: A Real - Time System for Forecasting Tropical Cyclone Storm Surges. *Weather and Forecasting*, **6 * *, 86 - 97
}
\keyword{internal}
