% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WindHazaRds.R
\name{returnBearing}
\alias{returnBearing}
\title{Return the Bearing for Line Segments}
\usage{
returnBearing(x)
}
\arguments{
\item{x}{spatial vector with line segments (two connected points)}
}
\value{
array of bearings see geosphere::bearing, i.e the Forward direction of the storm geographic bearing, positive clockwise from true north
}
\description{
Return the Bearing for Line Segments
}
\examples{
### IBTRACS HAS the WRONG BEARING!!
require(terra)
northwardTC <- vect(cbind(c(154,154),c(-26.1,-26)),"lines",crs="epsg:4283") #track line segment
easthwardTC <- vect(cbind(c(154,154.1),c(-26,-26)),"lines",crs="epsg:4283") #track line segment
southhwardTC <- vect(cbind(c(154,154),c(-26,-26.1)),"lines",crs="epsg:4283") #track line segment
westwardTC <- vect(cbind(c(154.1,154),c(-26,-26)),"lines",crs="epsg:4283") #track line segment
returnBearing(northwardTC)
returnBearing(easthwardTC)
returnBearing(southhwardTC)
returnBearing(westwardTC)
}
