% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{KepertVerticalWindField}
\alias{KepertVerticalWindField}
\title{Kepert Vertical Wind Field (u, v, Ks, w)}
\usage{
KepertVerticalWindField(
  rMax,
  vMax,
  vFm,
  thetaFm,
  f,
  Rlam,
  VZ,
  surface,
  dr_m = 10
)
}
\arguments{
\item{rMax}{radius of maximum winds in km}

\item{vMax}{maximum wind velocity in m/s}

\item{vFm}{forward speed of TC (m/s)}

\item{thetaFm}{forward direction of TC (deg)}

\item{f}{single coriolis parameter (1/s)}

\item{Rlam}{two columns: [radius_km, azimuth_deg] from grid point to TC centre}

\item{VZ}{two columns: [Vi (m/s), Zi (1/s)]}

\item{surface}{equals 1 for surface winds (reduced from gradient level),
otherwise gradient winds.}

\item{dr_m}{finite-difference step in metres (default 10 m)}
}
\value{
NumericMatrix with columns:
        1) u (m/s), 2) v (m/s), 3) Ks (-), 4) w (m/s)
}
\description{
As your KepertWindField but also computes vertical velocity
             w(r) = (1/r) * dQ/dr where
             Q(r) = r*C*Vg*(Vg + 2*vs) / ( f + Vg/r + dVg/dr ).
             Derivatives use 3-point stencils with radii r - dr, r, r + dr.
}
