% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixedtrace.R
\name{test_fixedtrace}
\alias{test_fixedtrace}
\alias{stat_fixedtrace}
\title{Test for eigenvalues when trace is fixed}
\usage{
test_fixedtrace(x, evals = NULL, B, maxit = 25)

stat_fixedtrace(x, evals = NULL)
}
\arguments{
\item{x}{A single sample of symmetric matrices or multiple samples of symmetric matrices. See \code{\link[=as_flat]{as_flat()}}.}

\item{evals}{When \code{x} is a single sample, the null hypothesis is that the (extrinsic) mean of the population has eigenvalues equal to \code{evals}. For multiple samples \code{evals} must be omitted.}

\item{B}{Number of bootstrap samples. If \code{B = 'chisq'} then a chi-squared calibration is used instead.}

\item{maxit}{The maximum number of Newton steps allowed in empirical likelihood optimisation \insertCite{owen:2013}{TFORGE}.}
}
\value{
A \code{TFORGE} object (see \code{\link[=boot_calib]{boot_calib()}} or \code{\link[=chisq_calib]{chisq_calib()}}) with the eigenvalues of the null hypothesis in the \code{null_evals} attribute for \code{t0}.
}
\description{
For a single sample of symmetric matrices with fixed trace, test eigenvalues of the population mean.
For multiple samples of symmetric matrices with fixed trace, test for equality of the eigenvalues of the population means.
The test statistic is calculated by \code{stat_fixedtrace()}.
}
\details{
Test hypotheses described below.
The fixed trace constraint forces the vector of eigenvalues to lie in a plane.
The test statistic accounts for this constraint by using an orthonormal basis in the plane.
Weighted bootstrap calibration is used (see 'Weighted Bootstrapping' below).

Eigenvalues must be distinct.

The test statistic is calculated by \code{stat_fixedtrace()}.
}
\section{Weighted Bootstrapping}{
This function uses a form of weighted bootstrapping called b-boostrapping \insertCite{hall1999in}{TFORGE}. An empirical distribution is defined by sampling weights for each observation in the original sample.
The sampling weights must be such that the (extrinsic) mean of the empirical distribution is \deqn{c\hat{Q} \Lambda \hat{Q}^\top,}
where \eqn{\hat{Q}} are the eigenvectors of the sample mean, \eqn{\Lambda} is a diagonal matrix of eigenvalues specified by either the null hypothesis (for single sample tests) or estimated as the common eigenvalues of multiple populations (for k-sample tests).
In some situations \eqn{c} is a free scalar to enable projection of the Euclidean mean to the extrinsic mean, otherwise \eqn{c=1}.
If no such sampling weights exist (i.e. the convex hull of the data does not contain \eqn{c\hat{Q} \Lambda \hat{Q}^\top}), then the test rejects with \code{pval=0} and a warning.

The sampling weights are also optimised to maximise empirical likelihood \insertCite{owen:2013}{TFORGE}.
}

\section{Hypotheses}{
For a single sample the null hypothesis is that the population (extrinsic) mean has eigenvalues of \code{evals}; the alternative hypothesis is that the eigenvalues are not equal to \code{evals}.
For multiple samples, \code{evals} must be omitted and the null hypothesis is that the population (extrinsic) means have the same eigenvalues.
}

\references{
\insertAllCited{}
}
