% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MDB.R
\name{MDB}
\alias{MDB}
\alias{names.MDB}
\alias{length.MDB}
\alias{lengths.MDB}
\alias{as.list.MDB}
\alias{select.MDB}
\alias{pull.MDB}
\alias{c.MDB}
\alias{merge.MDB}
\title{MDB}
\usage{
\method{names}{MDB}(x)

\method{length}{MDB}(x)

\method{lengths}{MDB}(x, use.names = TRUE)

\method{as.list}{MDB}(x, ...)

\method{select}{MDB}(.data, ...)

\method{pull}{MDB}(.data, var = -1, name = NULL, ...)

\method{c}{MDB}(...)

\method{merge}{MDB}(
  x,
  y,
  by = get_shared_collections(x, y),
  dbInfo = list(name = paste(db_info(x)$name, db_info(y)$name, sep = "_")),
  dmAutoLayout = TRUE,
  rtColor = "yellow",
  funs = list(),
  ...
)
}
\arguments{
\item{x}{an MDB object}

\item{use.names}{return the names of the tables}

\item{...}{additional parameters}

\item{.data}{an MDB object}

\item{var}{a variable specified as in \link[dplyr:pull]{dplyr::pull}}

\item{name}{not used but kept for compatibility with the generic function}

\item{y}{an MDB object}

\item{by}{a tibble as returned by the \code{\link[=get_shared_collections]{get_shared_collections()}} function
which indicates which collection members should be merged through
a relational table. If the collection is \code{NA}, the relational table is built
by merging identical columns in table.x and table.y. If the collection
is provided, the relational table is build using
the \code{\link[=map_collection_members]{map_collection_members()}} function.}

\item{dbInfo}{a list with DB information:
\strong{"name"} (only mandatory field), "title", "description", "url",
"version", "maintainer".}

\item{dmAutoLayout}{if TRUE (default) the layout of the merged data model
is automatically adjusted.}

\item{rtColor}{the color of the relational tables in the merged data model
(default: "yellow")}

\item{funs}{a named list of functions (default: list()). If there is
no function for mapping a collection in this list, it is taken
automatically using the \code{\link[=get_collection_mapper]{get_collection_mapper()}} function.}
}
\value{
\code{names()} returns the table names.

\code{length()} returns the number of tables in x.

\code{lengths()} returns the number of fields for each table in x.

\code{as.list.MDB()} returns a simple list of tibbles with all the
data from the tables in x.

A \link{metaMDB} object gathering x and y along
with relational tables between them created using collection members
and mapping functions automatically chosen or provided by
the \code{funs} parameter. \code{...} can be used to send parameters to the mapper
functions.
}
\description{
The class "MDB" provides general functions for handling
modeled databases.
The MDB classes implemented in the TKCat package
are: \link{fileMDB}, \link{memoMDB}, chMDB and \link{metaMDB}.
These classes provide additional functions.
}
\seealso{
MDB methods:
\link{db_info}, \link{data_model}, \link{data_tables}, \link{collection_members},
\link{count_records}, \link{filter_with_tables}, \link{as_fileMDB}
Additional documentation is provided for each specific class:
\link{fileMDB}, \link{memoMDB}, chMDB and \link{metaMDB}.
}
