% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TPLS.R
\name{makePredictor}
\alias{makePredictor}
\title{Method for extracting the T-PLS predictor at a given compval and threshval}
\usage{
makePredictor(TPLSmdl, compval, threshval)
}
\arguments{
\item{TPLSmdl}{A TPLS object created from using function \code{TPLS}}

\item{compval}{Vector of number of components to use in final predictor. Providing a vector will provide multiple betamaps (e.g., c(3,4,5) will provide three betamaps each with 3, 4, and 5 PLS components)}

\item{threshval}{Threshold number between 0 and 1 (inclusive) for thresholding the betamap. This must be a scalar.}
}
\value{
\itemize{
    \item \code{bias}: The intercept of the extracted model. Vector of intercepts if compval is a vector.
    \item \code{betamap}: Column vector of betamap. Matrix of betamaps if compval is a vector.
}
}
\description{
Method for extracting the T-PLS predictor at a given compval and threshval
}
