% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSplots.R
\name{SSplots}
\alias{SSplots}
\title{Automatic completion for Stress-Strain plots}
\usage{
SSplots(x, grpby, manual = NULL, legendscale = 0.7, ...)
}
\arguments{
\item{x}{A data frame with \code{\link[VBTree:VBTree-package]{VBTree}} style. Pay attention, all factors in column names
should be separated by "-" symbol, and factors for temperatures and strain rates should be saved in pure numeric style.}

\item{grpby}{Layer for variables to be grouped.}

\item{manual}{A positive integer vector with length 3. The first value is layer for Stress and Strain, the sencond value
is for Strain's level in this layer, and the third is Stress's level. Default setting is NULL, to call
\code{\link[TPMplt:lyIDdetector]{lyIDdetector}} automatically fill this argument.}

\item{legendscale}{A positive value to determine the scale of legend. Default value is 0.7}

\item{...}{Arguments be passed to \code{\link[graphics:par]{par}} for plots arrangements. \code{mfrow} and \code{mfcol} are
recommanded.}
}
\value{
Multiple Stress-Strain plots according to specified group methods.
}
\description{
Automatic completion for Stress-Strain plots
}
\examples{
\dontrun{
require(VBTree)
# Find locations for temperature and strain rate:
# temperature in layer2, strain rate in layer3;
# Strain in layer1 level1, Stress in layer1 level2.
dl2vbt(chrvec2dl(colnames(TPMdata)))

# Attention: Zoom your Plots panes large enough to ensure
# correct output!

# Plot multiple Stress-Strain curves, grouped by strain rate:
SSplots(TPMdata, 3, mfrow=c(3, 3))

# Plot multiple Stress-Strain curves, grouped by temperature:
SSplots(TPMdata, 2, mfrow=c(2, 2))

# Manual setting, for Stress-Stain plots:
SSplots(TPMdata, 2, manual=c(1, 1, 2), mfrow=c(2, 2))
}
}
\keyword{SSplots}
\keyword{lyIDdetector}
