% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCorrect.R
\name{TCorrect}
\alias{TCorrect}
\title{Adiabatic heating effect correction}
\usage{
TCorrect(
  x,
  lyT,
  lySR,
  eta,
  rho,
  c,
  StrainSeq,
  ACorrect = 1,
  manual = NULL,
  Amplifier = 1000
)
}
\arguments{
\item{x}{A data frame with \code{\link[VBTree:VBTree-package]{VBTree}} style. Pay attention, all factors
in column names should be separated by "-" symbol, and factors for temperatures and strain rates should be
saved in pure numeric style.}

\item{lyT}{An integer to specify the layer for temperature attribute in the vector binary tree.}

\item{lySR}{An integer to specify the layer for strain rate attribute in the vector binary tree.}

\item{eta}{Efficiency of deformation heating.}

\item{rho}{Density of materials, unit is g/cm^3.}

\item{c}{Heat capacity of materials, unit is J/(kg*K).}

\item{StrainSeq}{A vector to specify the sequence for flow strain.}

\item{ACorrect}{Coefficient to modify for density or heat capacity using different units. Default value
is 1.}

\item{manual}{An integer vector with the length of 3 where the 1st element denotes the layer for Stress and Strain,
the 2nd and 3rd elements represent the levels for Strain and Stress, respectively. The default setting is NULL, which
can call the function \code{\link[TPMplt:lyIDdetector]{lyIDdetector}} for automatical completion this vector.}

\item{Amplifier}{Amplifier for linear fitting. Default value is 1000.}
}
\value{
A data frame with \code{\link[VBTree:VBTree-package]{VBTree}} style including the adiabatic heating corrected
flow stress using the StrainSeq as conditions.
}
\description{
Adiabatic heating effect correction
}
\examples{
\donttest{
# Constants of steels as example:
dt_TC <- TCorrect(TPMdata, 2, 3, 0.9, 7.8, 502.416, seq(0, 0.9, 0.005))

# Data without adiabatic heating correction
SSplots(TPMdata, 2, mfrow=c(2, 2))

# Data with adiabatic heating correction
SSplots(dt_TC, 2, mfrow=c(2, 2))
}
}
\keyword{TCorrect}
