% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSDT_scoring_functions.R
\name{diff_quantile_response}
\alias{diff_quantile_response}
\title{diff_quantile_response}
\usage{
diff_quantile_response(data, scoring_function_parameters = NULL)
}
\arguments{
\item{data}{data.frame containing response data}

\item{scoring_function_parameters}{named list of scoring function control parameters}
}
\value{
A difference of response quantiles across treatment arms
}
\description{
Return the difference across treatment arms of a specified
response quantile
}
\details{
This function returns the difference across treatment arms of the
response quantile associated with a specified percentile. The default behavior
is to return the difference in medians.
}
\examples{
## Generate example data containing response and treatment
N <- 100
y = runif( min = 0, max = 20, n = N )
df <- as.data.frame( y )
names( df )  <- "y"
df$trt <- sample( c('Control','Experimental'), size = N, prob = c(0.4,0.6),
                  replace = TRUE )

## Default behavior is to return the median
diff_quantile_response( df )

# should match previous result from quantile_response
median( df$y[df$trt!='Control'] ) - median( df$y[df$trt=='Control'] )

## Get Q1 response
diff_quantile_response( df, scoring_function_parameters = list( percentile = 0.25 ) )

# should match previous result from quantile_response
quantile( df$y[df$trt!='Control'], 0.25 ) - quantile( df$y[df$trt=='Control'], 0.25 )

## Get max response
diff_quantile_response( df, scoring_function_parameters = list( percentile = 1 ) )

# should match previous result from quantile_response
max( df$y[df$trt!='Control'] ) -  max( df$y[df$trt=='Control'] )
}
\seealso{
\link{TSDT}, \link{quantile_response}, \link{quantile}
}
