% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsqca_cts.R
\name{ctSweepM}
\alias{ctSweepM}
\title{MCTS–QCA: Multi-condition threshold sweep}
\usage{
ctSweepM(
  dat,
  outcome = NULL,
  conditions = NULL,
  sweep_list,
  thrY,
  dir.exp = NULL,
  include = "?",
  incl.cut = 0.8,
  n.cut = 1,
  pri.cut = 0,
  extract_mode = c("first", "all", "essential"),
  return_details = TRUE,
  Yvar = NULL,
  Xvars = NULL
)
}
\arguments{
\item{dat}{Data frame containing the outcome and condition variables.}

\item{outcome}{Character. Outcome variable name. Supports negation with
tilde prefix (e.g., \code{"~Y"}) following QCA package conventions.}

\item{conditions}{Character vector. Names of condition variables.}

\item{sweep_list}{Named list. Each element is a numeric vector of
candidate thresholds for the corresponding X. Names must match
\code{conditions}.}

\item{thrY}{Numeric. Threshold for Y (fixed).}

\item{dir.exp}{Directional expectations for \code{minimize}.
If \code{NULL}, all set to 1.}

\item{include}{Inclusion rule for \code{minimize}.}

\item{incl.cut}{Consistency cutoff for \code{truthTable}.}

\item{n.cut}{Frequency cutoff for \code{truthTable}.}

\item{pri.cut}{PRI cutoff for \code{minimize}.}

\item{extract_mode}{Character. How to handle multiple solutions:
\code{"first"} (default), \code{"all"}, or \code{"essential"}.
See \code{\link{qca_extract}} for details.}

\item{return_details}{Logical. If \code{TRUE} (default), returns both
summary and detailed objects for use with \code{generate_report()}.}

\item{Yvar}{Deprecated. Use \code{outcome} instead.}

\item{Xvars}{Deprecated. Use \code{conditions} instead.}
}
\value{
If \code{return_details = FALSE}, a data frame with columns:
\itemize{
\item \code{combo_id} — index of the threshold combination
\item \code{threshold} — character string summarizing thresholds,
e.g. \code{"X1=6, X2=7, X3=7"}
\item \code{expression} — minimized solution expression
\item \code{inclS} — solution consistency
\item \code{covS} — solution coverage
\item (additional columns depending on \code{extract_mode})
}

If \code{return_details = TRUE}, a list with:
\itemize{
\item \code{summary} — the data frame above
\item \code{details} — per-combination list of
\code{combo_id}, \code{thrX_vec}, \code{truth_table}, \code{solution}
}
}
\description{
Performs a grid search over thresholds of multiple X variables.
For each combination of thresholds in \code{sweep_list}, the outcome Y
and all X variables are binarized, and a crisp-set QCA is executed.
}
\examples{
# Load sample data
data(sample_data)

# Quick demonstration with 2 conditions (< 5 seconds)
# This explores 2^2 = 4 threshold combinations
sweep_list <- list(
  X1 = 6:7,  # Reduced from 6:8 to 6:7
  X2 = 6:7   # Reduced from 6:8 to 6:7
)

# Run multiple condition threshold sweep with reduced parameters (standard)
result_quick <- ctSweepM(
  dat = sample_data,
  outcome = "Y",
  conditions = c("X1", "X2"),  # Reduced from 3 to 2 conditions
  sweep_list = sweep_list,
  thrY = 7
)
head(result_quick$summary)

# Run with negated outcome (~Y)
result_neg <- ctSweepM(
  dat = sample_data,
  outcome = "~Y",
  conditions = c("X1", "X2"),
  sweep_list = sweep_list,
  thrY = 7
)
head(result_neg$summary)

\donttest{
# Full multi-condition analysis with 3 conditions
# This explores 3^3 = 27 threshold combinations (takes ~5-8 seconds)
sweep_list_full <- list(
  X1 = 6:8,
  X2 = 6:8,
  X3 = 6:8
)

result_full <- ctSweepM(
  dat = sample_data,
  outcome = "Y",
  conditions = c("X1", "X2", "X3"),
  sweep_list = sweep_list_full,
  thrY = 7
)

# Visualize threshold-dependent solution paths
head(result_full$summary)
}
}
