% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClimateAccumulator.R
\name{climate.accumulator}
\alias{climate.accumulator}
\title{Climate Accumulator}
\usage{
climate.accumulator(CTSR.VI, clim.data, max.acp, max.osp)
}
\arguments{
\item{CTSR.VI}{Complete Time Series of Vegetation Index. An object of class \code{'ts'}. Monthly time series of VI values}

\item{clim.data}{Complete Time Series of monthly rainfall or temperature. An object of class \code{'ts'}. Must
have the same end date as CTSR.VI and be longer than the CTSR.VI by more than the max acsumuation
period (max.acp) plus the max offset period.(max.ops)}

\item{max.acp}{The max accumuation period. Must be an integer > 1.}

\item{max.osp}{The max offset period. Must be an integer >1}
}
\value{
ACP.table
A matrix with ever possible accumuated climate combination
}
\description{
Takes the time series of rainfall and returns a rainfall accumulation table of every possible combination
of the max accumulation period and the max offset period.
}
\examples{
# Define the max accumuulation period
acp <- 12
#Define the max offset period
osp <- 4
rftable <- climate.accumulator(segRESTRENDCTSR$cts.NDVI, segRESTRENDctRF$precip, acp, osp)
}

