% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{repr_seas_profile}
\alias{repr_seas_profile}
\title{Mean seasonal profile of time series}
\usage{
repr_seas_profile(x, freq, func)
}
\arguments{
\item{x}{the numeric vector (time series)}

\item{freq}{the integer of the length of the season}

\item{func}{the aggregation function. Can be meanC or medianC or similar aggregation function.}
}
\value{
the numeric vector
}
\description{
The \code{repr_seas_profile} computes mean seasonal profile representation from a time series.
}
\details{
This function computes mean seasonal profile representation for a seasonal time series.
The length of representation is length of set seasonality (frequency) of a time series.
Aggregation function is arbitrary (best choice is for you maybe mean or median).
}
\examples{
repr_seas_profile(rnorm(48*10), 48, meanC)

}
\references{
Laurinec P, Lucka M (2016)
Comparison of representations of time series for clustering smart meter data.
In: Lecture Notes in Engineering and Computer Science: Proceedings of The World Congress on Engineering and Computer Science 2016, pp 458-463

Laurinec P, Loderer M, Vrablecova P, Lucka M, Rozinajova V, Ezzeddine AB (2016)
Adaptive time series forecasting of energy consumption using optimized cluster analysis.
In: Data Mining Workshops (ICDMW), 2016 IEEE 16th International Conference on, IEEE, pp 398-405
}
\seealso{
\code{\link[TSrepr]{repr_lm}, \link[TSrepr]{repr_gam}, \link[TSrepr]{repr_exp}}
}
\author{
Peter Laurinec, <tsreprpackage@gmail.com>
}
