% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_functions.R
\name{ts_lags}
\alias{ts_lags}
\title{Time Series Lag Visualization}
\usage{
ts_lags(ts.obj, lags = 1:12, margin = 0.02, Xshare = TRUE,
  Yshare = TRUE, n_plots = 3)
}
\arguments{
\item{ts.obj}{A univariate time series object of a class "ts", "zoo" or "xts"}

\item{lags}{An integer, set the lags range, by default will plot the first 12 lags}

\item{margin}{Plotly parameter, either a single value or four values (all between 0 and 1).
If four values provided, the first will be used as the left margin, 
the second will be used as the right margin, 
the third will be used as the top margin, 
and the fourth will be used as the bottom margin. 
If a single value provided, it will be used as all four margins.}

\item{Xshare}{Plotly parameter, should the x-axis be shared amongst the subplots?}

\item{Yshare}{Plotly parameter, should the y-axis be shared amongst the subplots?}

\item{n_plots}{An integer, define the number of plots per row}
}
\description{
Visualization of series with its lags, 
can be used to identify a correlation between the series and it lags
}
\examples{
data(USgas)

# Plot the first 12 lags (default)
ts_lags(USgas) 

# Plot the seasonal lags for the first 4 years (hence, lag 12, 24, 36, 48)
ts_lags(USgas, lags = c(12, 24, 36, 48))

# Setting the margin between the plot
ts_lags(USgas, lags = c(12, 24, 36, 48), margin = 0.01)
}
