% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tprBiomass.r
\name{tprBiomass}
\alias{tprBiomass}
\alias{tprBiomass,tprTrees-method}
\title{total aboveground and component biomass}
\usage{
tprBiomass(obj, component = NULL, mono = TRUE, Rfn = NULL)

\S4method{tprBiomass}{tprTrees}(obj, component = NULL, mono = TRUE, Rfn = NULL)
}
\arguments{
\item{obj}{object of class 'tprTrees'}

\item{component}{component for which biomass should be returned. If NULL,
total aboveground biomass is returned, if 'all', all components are returned.
See details.}

\item{mono}{logical, defaults to true. If calibrated taper curve is
non-monotonic at stem base, a support diameter is added.}

\item{Rfn}{Rfn setting for residuals error matrix, defaults to
\code{list(fn="sig2")}, see \code{\link[TapeR]{resVar}}.}
}
\value{
a vector in case agb or only one component is requested, otherwise
a matrix with one row per tree
}
\description{
calculate total above ground and optionally component biomass
for given trees
}
\details{
The available components are agb (= total aboveground biomass),
stw (=stump wood), stb (=stump bark), sw (=solid wood with diameter above
 7cm over bark), sb (=bark of component sw), fwb (=fine wood incl. bark)
 and ndl (=needles), if applicable. The needles-component is set to zero for
 deciduous tree species, no mass for leaves is available. One can request
 'all' components to receive all components.
}
\section{Methods (by class)}{
\itemize{
\item \code{tprBiomass(tprTrees)}: method for class 'tprTrees'

}}
\examples{
obj <- tprTrees(spp=c(1, 15),
                Dm=list(c(30, 28), c(30, 28)),
                Hm=list(c(1, 3), c(1, 3)),
                Ht = rep(30, 2))
## OBS: component 'ndl' NOT included to aboveground biomass 'agb'
(tmp <- tprBiomass(obj, component="all"))
rowSums(tmp[, -which(colnames(tmp) \%in\% c("agb", "ndl"))])
## equal to
tmp$agb
tprBiomass(obj, component=NULL) # aboveground biomass
component <- c("agb", "sw", "sb", "ndl")
tprBiomass(obj, component=component)
component <- c("sw", "sb", "ndl")
tprBiomass(obj, component=component)
}
\references{
Kändler, G. and B. Bösch (2012). Methodenentwicklung für die
3. Bundeswaldinventur: Modul 3 Überprüfung und Neukonzeption einer
Biomassefunktion - Abschlussbericht. Im Auftrag des Bundesministeriums für
Ernährung, Landwirtschaft und Verbraucherschutz in Zusammenarbeit mit dem
Institut für Waldökologie und Waldinventur des Johann Heinrich von
Thünen-Instituts, FVA-BW: 71.

Kaendler (2021): AFJZ article, in press.
}
