% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dbh.r
\name{Dbh}
\alias{Dbh}
\alias{Bhd}
\alias{D13}
\alias{D7}
\alias{D03}
\alias{D005}
\title{Extract pre-defined diameter}
\usage{
Dbh(obj)

Bhd(obj)

D13(obj)

D7(obj)

D03(obj)

D005(obj)
}
\arguments{
\item{obj}{a object of class 'tprTrees'}
}
\value{
diameter(s) in predefined heights
}
\description{
Function extracts pre-defined diameters, e.g. dbh (in 1.3m) or
D03 (in 30\% of tree height) for a \code{\link{tprTrees}}-object
}
\details{
a wrapper around \code{\link{tprDiameter}} to calculate specifically
defined diameters like diameter in breast height (dbh), diameter in 7m above
ground or in 5\% and 30\% of tree height.
}
\section{Functions}{
\itemize{
\item \code{Dbh()}: wrapper to calculate diameter in breast height

\item \code{Bhd()}: German alias for function Dbh

\item \code{D13()}: Height specific alias for function Dbh

\item \code{D7()}: Function to calculate diameter over bark in 7m above ground

\item \code{D03()}: Function to calculate diameter over bark in 30\% of tree height

\item \code{D005()}: Function to calculate diameter over bark in 5\% of tree height

}}
\examples{
t <- tprTrees()
Dbh(t) # diameter in breast height (i.e. 1.3m)
Bhd(t) # same, german named function name
D13(t) # same, height related function name
D005(t) # diameter in 5\% of tree height
D7(t) # diameter in height of 7m
D03(t) # diameter in 30\% of tree height
}
