% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{nsur}
\alias{nsur}
\title{Component biomass functions}
\usage{
nsur(spp, dbh, ht, sth, d03, kl)
}
\arguments{
\item{spp}{vector of species code for biomass component function of interval
[1;8]; see \code{\link{BaMap}} for mapping of species model codes}

\item{dbh}{vector of diameter in breast height; in centimeter}

\item{ht}{vector of tree heights, in meter}

\item{sth}{vector of stump heights, in meter}

\item{d03}{vector if diameter in 30\% of tree height, in centimeter}

\item{kl}{vector of crown length, i.e. tree height minus height of crown base, in meter}
}
\value{
a numeric matrix holding component biomass
}
\description{
evaluation of the component biomass functions fit by nonlinear seemingly
unrelated regression (NSUR) to estimate absolute or relative component mass
}
\details{
function to calculate component biomass; functions fitted using
same methodology as in Vonderach et al. (2018) with slightly updated
parameters as in Vonderach and Kändler (2021); species mapping as in
\code{TapeS::BaMap(, type=7)};
}
\examples{
nsur(spp = c(1, 6),
     dbh = c(30, 30),
     ht = c(25, 27),
     sth = c(0.25, 0.27),
     d03 = c(27, 27),
     kl = .7*c(25, 27))
}
\references{
Vonderach, C., G. Kändler and C. F. Dormann (2018).
"Consistent set of additive biomass functions for eight tree species in
Germany fit by nonlinear seemingly unrelated regression."
Annals of Forest Science 75(2): 49.
\doi{10.1007/s13595-018-0728-4}

Vonderach, C. and G. Kändler (2021). Neuentwicklung von Schaftkurven- und
Biomassemodellen für die Bundeswaldinventur auf Basis des TapeR-Pakets -
Abschlussbericht zum Projekt BWI-TapeR. Freiburg: 150p.
}
