% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.tca.R
\name{plot.tca}
\alias{plot.tca}
\title{Creates a symmetric plot from a tca-class object}
\usage{
\method{plot}{tca}(x, y = NULL, axes = c(1, 2), labels.rc = c(0, 1),
  col.rc = c("blue", "red"), pch.rc = c(16, 21, 17, 24), mass.rc = c(F,
  F), cex.rc = c(NA, NA), jitter = c(T, F), ...)
}
\arguments{
\item{x}{A tca-class object created by tca}

\item{y}{Unused}

\item{axes}{The two axes to be plotted}

\item{labels.rc}{Two numbers: 0 Symbol only; 1 Label only; 2 Symbol and label}

\item{col.rc}{Colors for rows and columns contributions}

\item{pch.rc}{Plotting characters for rows and columns contributions}

\item{mass.rc}{Logical: Will the area of plotting characters be proportional to mass}

\item{cex.rc}{An overall size factor}

\item{jitter}{Logical: Will close points be moved slightly?}

\item{...}{Unused.}
}
\value{
None
}
\description{
Creates a symmetric plot from a tca-class object
}
\details{
If the number of rows is very large, labels will not be printed.

In this version, jitter is coerced.
}
\examples{
plot(tca(rodent),labels=c(0,1))

}
