% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicfcts_TS.R
\name{pNTS}
\alias{pNTS}
\title{Cumulative probability function of the normal tempered stable (NTS)
distribution}
\usage{
pNTS(
  q,
  alpha = NULL,
  beta = NULL,
  delta = NULL,
  lambda = NULL,
  mu = NULL,
  theta = NULL,
  a = -40,
  b = 40,
  nf = 2^11,
  ...
)
}
\arguments{
\item{q}{A numeric vector of quantile.}

\item{alpha}{A real number between 0 and 1.}

\item{beta}{Any real number.}

\item{delta}{A real number > 0.}

\item{lambda}{A  real number > 0.}

\item{mu}{A location parameter, any real number.}

\item{theta}{A vector of all other arguments.}

\item{a}{Starting point integrate density function. -40 by default.}

\item{b}{Ending point of integrate density function. 40 by default.}

\item{nf}{Pieces the fast Fourier transformation is divided in. Limited to
power-of-two size. 2^11 by default.}

\item{...}{Change parameters in \code{\link[=dNTS]{dNTS()}}}
}
\value{
As \code{q} is a numeric vector, the return value is also a numeric
vector of probabilities.
}
\description{
The cumulative probability distribution function (CDF) of the normal
tempered stable distribution.
}
\details{
\code{theta} denotes the parameter vector \code{(alpha, beta, delta, lambda,
mu)}. Either provide the parameters individually OR provide \code{theta}.
The function integrates the PDF numerically with \code{integrate()}.
}
\examples{
\donttest{
x <- seq(-5,5,0.25)
y <- pNTS(x,0.5,1,1,1,1)
plot(x,y)
}

}
\seealso{
See also the \code{\link[=dNTS]{dNTS()}} density-function.
}
