% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signT.R
\name{Altopt}
\alias{Altopt}
\title{Alternating optimization of the weighted classification loss}
\usage{
Altopt(Ybar,W,r,type = c("logistic","hinge"),start = "linear")
}
\arguments{
\item{Ybar}{A given (possibly noisy and incomplete) data tensor.}

\item{W}{A weight tensor used in the weighted classification loss.}

\item{r}{A rank to be fitted (CP rank).}

\item{type}{A large margin loss to be used. Logistic or hinge loss is available.}

\item{start}{Choice of initialization method. Use random initialization if \code{start} = "random"; Use the initialization based on low rank approximation if \code{start} = "linear". Linear initialization is default.}
}
\value{
The returned object is a list of components.

\code{binary_obj} - Trajectory of binary loss values over iterations.

\code{obj} - Trajectory of weighted classification loss values over iterations.

\code{iter} - The number of iterations.

\code{error} - Trajectory of errors over iterations.

\code{fitted} - A tensor that optimizes the weighted classification loss.
}
\description{
Optimize the weighted classification loss given a weight tensor, an observed data tensor, and a large margin loss. This function is used as a subroutine in the main function \code{fit_nonparaT}.
}
\examples{
library(tensorregress)
indices = c(2,2,2)
noise = rand_tensor(indices)@data
Theta = array(runif(prod(indices),min=-3,max = 3),indices)

# The signal plus noise model
Y = Theta + noise

# Optimize the weighted classification for given a sign tensor sign(Y) and a weight tensor abs(Y)
result = Altopt(sign(Y),abs(Y),r = 3,type = "hinge",start = "linear")
signTheta = sign(result$fitted)

}
\references{
C. Lee and M. Wang. Beyond the Signs: Nonparametric Tensor Completion via Sign Series. \emph{Neural Information Processing Systems 34 (NeurIPS)}, 2021.
}
