% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Contours.R
\name{ColourTernary}
\alias{ColourTernary}
\title{Colour a ternary plot according to the output of a function}
\usage{
ColourTernary(values, spectrum = viridisLite::viridis(256L, alpha = 0.6),
  resolution = sqrt(ncol(values)),
  direction = getOption("ternDirection"))
}
\arguments{
\item{values}{Numeric vector specifying the values associated with each point,
generated using \code{\link{TernaryPointValues}}.}

\item{spectrum}{Vector of colours to use as a spectrum.}

\item{resolution}{The number of triangles whose base should lie on the longest
axis of the triangle.  Higher numbers will result in smaller subdivisions and smoother
colour gradients, but at a computational cost.}

\item{direction}{(optional) Integer specifying the direction that the current ternary plot
should point: 1, up; 2, right; 3, down; 4, left.}
}
\description{
Colour a ternary plot according to the output of a function
}
\seealso{
Other contour plotting functions: \code{\link{TernaryContour}},
  \code{\link{TernaryDensityContour}},
  \code{\link{TernaryPointValues}}
}
\author{
Martin R. Smith
}
\concept{contour plotting functions}
