% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions1.R
\name{TF_branin}
\alias{TF_branin}
\alias{TF_borehole}
\alias{TF_franke}
\alias{TF_zhou1998}
\alias{TF_currin1991}
\alias{TF_lim2002}
\alias{TF_banana}
\alias{TF_gaussian1}
\alias{TF_sinumoid}
\alias{TF_sqrtsin}
\alias{TF_powsin}
\alias{TF_OTL_Circuit}
\title{Base test function.}
\usage{
TF_branin(x, a = 1, b = 5.1/(4 * pi^2), cc = 5/pi, r = 6, s = 10,
  tt = 1/(8 * pi))

TF_borehole(x)

TF_franke(x)

TF_zhou1998(x)

TF_currin1991(x)

TF_lim2002(x)

TF_banana(x)

TF_gaussian1(x, center = 0.5, s2 = 0.01)

TF_sinumoid(x)

TF_sqrtsin(x, freq = 2 * pi)

TF_powsin(x, freq = 2 * pi, pow = 0.7)

TF_OTL_Circuit(x)
}
\arguments{
\item{x}{Input vector at which to evaluate.}

\item{a}{Parameter for TF_branin}

\item{b}{Parameter for TF_branin}

\item{cc}{Parameter for TF_branin}

\item{r}{Parameter for TF_branin}

\item{s}{Parameter for TF_branin}

\item{tt}{Parameter for TF_branin}

\item{center}{Where to center the function, a vector.}

\item{s2}{Variance of the Gaussian.}

\item{freq}{Wave frequency for TF_sqrtsin and TF_powsin}

\item{pow}{Power to raise wave to for TF_powsin.}
}
\value{
Function output evaluated at x.
}
\description{
TF_branin: A function taking in a single vector.
2 dimensional function.
See corresponding function with "TF_" for more details.

TF_borehole: A function taking in a single vector.
8 dimensional function.
See corresponding function with "TF_" for more details.

TF_franke: A function taking in a single vector.
2 dimensional function.
See corresponding function with "TF_" for more details.

TF_zhou1998: A function taking in a single vector.
2 dimensional function.
See corresponding function with "TF_" for more details.

TF_currin1991: A function taking in a single vector.
2 dimensional function.
See corresponding function with "TF_" for more details.

TF_lim2002: A function taking in a single vector.
2 dimensional function.
See corresponding function with "TF_" for more details.

TF_banana: A function taking in a single vector.
2 dimensional function.
See corresponding function with "TF_" for more details.

TF_gaussian1: A function taking in a single vector.
Any dimensional function.
See corresponding function with "TF_" for more details.

TF_sinumoid: A function taking in a single vector.
2 dimensional function.
See corresponding function with "TF_" for more details.

TF_sqrtsin: A function taking in a single vector.
Any dimensional function.
See corresponding function with "TF_" for more details.

TF_powsin: A function taking in a single vector.
Any dimensional function.
See corresponding function with "TF_" for more details.

TF_OTL_Circuit: OTL Circuit function for evaluating a single point
}
\examples{
TF_branin(runif(2))
TF_borehole(runif(8))
TF_franke(runif(2))
TF_zhou1998(runif(2))
TF_currin1991(runif(2))
TF_lim2002(runif(2))
TF_banana(runif(2))
TF_gaussian1(runif(2))
TF_sinumoid(runif(2))
TF_sqrtsin(runif(2))
TF_powsin(runif(2))
TF_OTL_Circuit(c(50,25,0.5,1.2,0.25,50))
}
