% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patients.R
\name{patientsCDM}
\alias{patientsCDM}
\title{Pushes test population into a blank CDM.}
\usage{
patientsCDM(pathJson = NULL, testName = NULL, cdmVersion = "5.3")
}
\arguments{
\item{pathJson}{Directory where the sample populations in json are located. If NULL, gets the default inst/testCases directory.}

\item{testName}{Name of the sample population JSON file. If NULL it will push the first sample population in the testCases directory.}

\item{cdmVersion}{cdm version, default "5.3".}
}
\value{
A CDM reference object with a sample population.
}
\description{
Pushes test population into a blank CDM.
}
\examples{
\donttest{
filePath <- system.file("extdata", "testPatientsRSV.xlsx", package = "TestGenerator")
TestGenerator::readPatients(filePath = filePath, outputPath = tempdir())
cdm <- TestGenerator::patientsCDM(pathJson = tempdir(), testName = "test")
duckdb::duckdb_shutdown(duckdb::duckdb())
}
}
