% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jsonparser.R
\name{jsonexamparser}
\alias{jsonexamparser}
\title{Json Exam Document Parser}
\usage{
jsonexamparser(opt)
}
\arguments{
\item{opt}{Options as parsed from \code{\link[optparse]{parse_args}}. The function expects a series of options, the example code exemplifies those options that the function understands.}
}
\description{
This function takes a series of options as obtained from \code{\link[optparse]{parse_args}} through the parameter \code{opt}. The "examples" section provides all the options that it can parse.

From within those options, a \code{--file} option is mandatory.

The file option provides a 'LaTeX' file name in which to search for lines on the preamble \code{\%!TexExamRandomizer} within the first 200 lines.

With those options that it finds through tags, it passes the function \code{\link{CreateRandomExams}}.

Note that the tags must respect the JSON format, that is. It \emph{needs} to be written within double quotes.
}
\details{
All the options can be found on

\code{vignette("ExamOptions", package = "TexExamRandomizer")}

The options that are called "command line" options in the vignette are those that are given to the function through \code{opt}, the rest of the options are read directly froo the document specified with \code{--file <filename>}
}
\examples{
\dontrun{
#!/bin/Rscript
#This example showcases the type of script this jsonparser might be used on.
# You can still use it without a script,
# just by adding a list that has the same names as the list provided in opt
library(optparse)
option_list <- list(
    make_option(
        c("--file"),
        action = "store",
        default = NULL,
        type = 'character',
        help = "Filename of the Tex File"
    ),
    make_option(
        c("--table"),
        action = "store",
        default = NULL,
        type = 'character',
        help = "Filename of the table to break down. It overwrites the values written on the file"
    ),
    make_option(
        c("-n", "--noutput"),
        action = "store",
        default = NULL,
        type = "integer",
        help = "Number of output Versions"
    ),
    make_option(
        c("-q", "--nquestions"),
        action = "store",
        default = NULL,
        type = "character",
        help = "Number of output questions"
    ),
    make_option(
        c("-s", "--seed"),
        action = "store",
        default = NULL,
        type = "integer",
        help = "Seed for any randomization done"
    ),
    make_option(
        c("-c", "--compile"),
        action = "store_true",
        default = FALSE,
        type = "logical",
        help = "Should the output folder be compiled or not"
    ),
    make_option(
        c("--xelatex"),
        action = "store_true",
        default = FALSE,
        type = "logical",
        help = "Should we use xelatex to compile or not"
    ),
    make_option(
        c("-d", "--debug"),
        action = "store_true",
        default = FALSE,
        type = "logical",
        help = "If debugging, it doesn't remove auxiliary files"
    )
)


#### PARSING OPTIONS ####
####
opt <-
    parse_args(
        OptionParser(option_list = option_list),
        positional_arguments = TRUE
    )

# Let's assume the file was the example file
testfile <-
    system.file(
        "extdata",
        "ExampleTexDocuments",
        "exam_testing_nquestions.tex", #Test exam that doesn't require a table
        package = "TexExamRandomizer")

# To prevent modifying the file system in examples
temporalfile <- paste(tempfile(), ".tex", sep = "")

file.copy(testfile, temporalfile)

opt$options$file <- temporalfile



jsonexamparser(opt)
}

}
\seealso{
Other jsoncompiler: \code{\link{ParsePreambleForOptions}},
  \code{\link{jsonhwparser}}
}
