% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.lmHetero.R
\name{summary.lmHetero}
\alias{summary.lmHetero}
\title{Function: Summerize lmHetero model estimates}
\usage{
\method{summary}{lmHetero}(object, ...)
}
\arguments{
\item{object}{An object of S3-class \code{lmHetero}.}

\item{...}{Currently not in use.}
}
\value{
the input 'object' is returned silently.
}
\description{
\code{summary.lmHetero} provides relevant summary information of a
heteroscedastic regression model estimated by \code{lmHetero}.
}
\details{
Regression tables for the estimate regression coefficients and the
coefficients of the weights model are provided as well as a maximum
likelihood ratio test is performed against a model, which assumes homoscedasticity.
}
\examples{
library(sp)
data(tractShp)
validTractShp <- tractShp[!is.na(tractShp$BUYPOW), ]         # Remove 2 tracts with NA's
## Population at risk
totPop <- validTractShp$MALE+validTractShp$FEMALE

## H0 model
mod.lm <- mod.lmH <- lmHetero(PERCAPINC~PCTNOHINS+PCTMINOR+PCTUNIVDEG+PCTWHITE,
                              data=validTractShp)
summary(mod.lm)

## Preferred function call
mod.lmH <- lmHetero(PERCAPINC~PCTNOHINS+PCTMINOR+PCTUNIVDEG+PCTWHITE|log(totPop),
                    data=validTractShp)
summary(mod.lmH)

## Alternative function call
mod.lmH <- lmHetero(PERCAPINC~PCTNOHINS+PCTMINOR+PCTUNIVDEG+PCTWHITE, hetero=~log(totPop),
                    data=validTractShp)
summary(mod.lmH)

## Use estimated weights as input for weighted lm
mod.lmW <- lm(PERCAPINC~PCTNOHINS+PCTMINOR+PCTUNIVDEG+PCTWHITE, weights=mod.lmH$weights,
              data=validTractShp)
summary(mod.lmW)
hist(weighted.residuals(mod.lmW))

}
\author{
Michael Tiefelsdorf \email{tiefelsdorf@utdallas.edu}
}
