% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CircosFruits.R
\name{add_new_tile_layer}
\alias{add_new_tile_layer}
\title{Add a new tile layer with dynamic scales to a `ggtree` plot}
\usage{
add_new_tile_layer(
  p,
  data,
  gene_colors,
  gene_label,
  alpha_value = c(0.3, 0.9),
  offset = 0.02,
  pwidth = 2
)
}
\arguments{
\item{p}{An existing ggtree plot object.}

\item{data}{A data frame containing the data to be plotted. Expected to have columns for 'Sample', 'Gene', and 'value'.}

\item{gene_colors}{A named vector of colors for genes.}

\item{gene_label}{A character string used as a label in the legend for the genes.}

\item{alpha_value}{A numeric or named vector for setting the alpha scale based on values.}

\item{offset}{Numeric value, the position of the tile on the x-axis relative to its gene name. Default is 0.02.}

\item{pwidth}{Numeric value, the width of the tile. Default is 2.}
}
\value{
A `ggtree` plot object with the added tile layer and new scales.
}
\description{
This function adds a new tile layer to an existing `ggtree` plot object, allowing for separate scales for fill
and alpha transparency. This is useful when you want to add additional data layers without interfering with
the existing scales in the plot. It utilizes the 'ggnewscale' package to reset scales for new layers.
}
\examples{
\donttest{
# Check and load required packages
if (requireNamespace("ggtreeExtra", quietly = TRUE) &&
 requireNamespace("ggplot2", quietly = TRUE) &&
  requireNamespace("ggnewscale", quietly = TRUE)) {
  library(ggtreeExtra)
  library(ggplot2)
  library(ggnewscale)

  file_path <- system.file("extdata", "p_tree_test.rds", package = "TransProR")
  p <- readRDS(file_path)

  # Create new expression data
  new_expression_data <- data.frame(
    Sample = rep(c("Species_A", "Species_B", "Species_C", "Species_D"), each = 3),
    Gene = rep(c("Gene6", "Gene7", "Gene8"), times = 4),
    Value = runif(12, min = 0, max = 1)  # Randomly generate expression values between 0 and 1
  )

  # Define new gene colors
  new_gene_colors <- c(
    Gene6 = "#0b5f63",
    Gene7 = "#074d41",
    Gene8 = "#1f5e27"
  )

  # Define gene label and alpha values
  gene_label <- "New Genes"
  alpha_value <- c(0.3, 0.9)

  # Add new tile layer
  p_with_new_layer <- add_new_tile_layer(
    p,
    new_expression_data,
    new_gene_colors,
    gene_label,
    alpha_value,
    offset = 0.02,
    pwidth = 2
  )
} else {
  message("Required packages 'ggtreeExtra', 'ggplot2', and 'ggnewscale' are not installed.")
}
}

}
