% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dql.ad.R
\name{dql.ad}
\alias{dql.ad}
\title{Analise de experimento  conduzido no delineamento em quadrado latino com
testemunhas adicionais}
\usage{
dql.ad(Dados,alfa=0.05,quali=TRUE,verbose=TRUE)
}
\arguments{
\item{Dados}{Matriz contendo na primeira coluna a identificacao dos
testemunhas (tratamentos comuns deve ter valor zero ou NA). A segunda coluna
deve ter a identificacao de todos os tratamentos.  A terceira coluna a
identificacao dos linhas. A quarta coluna a identificacao das colunas.
 A quinta coluna a variavel resposta.}

\item{alfa}{valor indicando o nivel de significancia deve ser
obrigatoriamente "0.001", "0.01", "0.05" ou "0.10" (default = 0.05).}

\item{quali}{Valor logico (TRUE/FALSE). TRUE indica que o tratamento e
qualitativo, realizando-se o teste de medias. FALSE indica que o fator e
quantitativo, sendo feita a analise de regressao.}

\item{verbose}{Valor logico (TRUE/FALSE). TRUE apresenta os resultados da analise.}
}
\value{
Retorna a comparacao multipla de medias obtida por varios testes.
}
\description{
Esta funcao retorna a comparacao multipla de medias (obtidas
 pelos testes t, t com protecao de Bonferroni, Duncan, Dunnet, SNK, Tukey e
 Scott-Knott) se os tratamentos for qualitativos. Ou a analise de regressao
 se os tratamentos forem quantitativos. Para comparar a testemunha adicional
 com os demais e utilizado o teste Dunnet. Esta funcao considera o
 delineamento em quadrados latinos.
}
\examples{
 ######
 #Exemplo de um experimento em DQL com tratamentos qualitativos e duas
 #testemunhas adicionais
 ?dql.ad
 data(Dados7)
 dql.ad(Dados = Dados7,alfa = 0.05,quali =TRUE)
 #Exemplo de um experimento em DQL com tratamentos quantitativos e uma
 #testemunha adicional
 data(Dados8)
 dql.ad(Dados = Dados8,alfa = 0.05,quali =FALSE)
}
\references{
<https://www.youtube.com/playlist?list=PLvth1ZcREyK4wSzwg-IxvrzaNzSLLrXEB>

 BANZATTO, D. A.; KRONKA, S. N. Experimentacao Agricola. 4 ed.
 Jaboticabal: Funep. 2006. 237 p.

 GOMES, F. P. Curso de Estatistica Experimental. 10a ed. Piracicaba:
 ESALQ/USP. 1982. 430.
}
\author{
Alcinei Mistico Azevedo, \email{alcineimistico@hotmail.com}
}
