% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lap.R
\name{LAPJV}
\alias{LAPJV}
\title{Solve linear assignment problem using LAPJV}
\usage{
LAPJV(x)
}
\arguments{
\item{x}{Matrix of costs.}
}
\value{
\code{LAPJV()} returns a list with two entries: \code{score}, the score of the
optimal matching;
and \code{matching}, the columns matched to each row of the matrix in turn.
}
\description{
Use the algorithm of \insertCite{Jonker1987;textual}{TreeDist} to solve the
\href{http://www.assignmentproblems.com/doc/LSAPIntroduction.pdf}{Linear Sum Assignment Problem}.
}
\details{
The Linear Assignment Problem seeks to match each row of a matrix with a
column, such that the cost of the matching is minimized.

The Jonker & Volgenant approach is a faster alternative to the Hungarian
algorithm \insertCite{Munkres1957}{TreeDist}, which is implemented in
\code{clue::solve_LSAP()}.

Note: the JV algorithm expects integers. In order to apply the function
to a non-integer \emph{n}, as in the tree distance calculations in this package,
each \emph{n} is multiplied by the largest available integer before applying
the JV algorithm.  If two values of \emph{n} exhibit a trivial difference --
e.g. due to floating point errors -- then this can lead to interminable
run times.  (If numbers of the magnitude of billions differ only in their
last significant digit, then the JV algorithm may undergo billions of
iterations.)  To avoid this, integers over 2^22 that differ by a value of
8 or less are treated as equal.
}
\examples{
problem <- matrix(c(7, 9, 8, 9, 9,
                    2, 8, 5, 7, 9,
                    1, 6, 6, 9, 9,
                    3, 6, 2, 2, 9), 4, 5, byrow = TRUE)

LAPJV(problem)
}
\references{
\insertAllCited{}
}
\seealso{
Implementations of the Hungarian algorithm exist in \pkg{adagio},
\pkg{RcppHungarian}, and \pkg{clue} and \pkg{lpSolve}; for larger matrices,
these are substantially slower. (See discussion at \href{https://stackoverflow.com/questions/72806265/}{Stack Overflow}.)

The JV algorithm is implemented for square matrices in the Bioconductor
package \href{https://www.bioconductor.org/packages/release/bioc/html/GraphAlignment.html}{\code{GraphAlignment::LinearAssignment()}}.
}
\author{
\href{https://github.com/yongyanghz/LAPJV-algorithm-c/blob/master/LAPJV/lap.cpp}{C++ code}
by Roy Jonker, MagicLogic Optimization Inc. \href{mailto:roy_jonker@magiclogic.com}{roy_jonker@magiclogic.com},
with contributions from Yong Yang \href{mailto:yongyanglink@gmail.com}{yongyanglink@gmail.com}, after
\href{https://uk.mathworks.com/matlabcentral/profile/authors/69713-yi-cao}{Yi Cao}
}
