% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_distance_spr.R
\name{SPRDist}
\alias{SPRDist}
\alias{SPRDist.phylo}
\alias{SPRDist.list}
\alias{SPRDist.multiPhylo}
\title{Approximate the Subtree Prune and Regraft (SPR) distance.}
\usage{
SPRDist(tree1, tree2 = NULL, method = "deOliveira", symmetric)

\method{SPRDist}{phylo}(tree1, tree2 = NULL, method = "deOliveira", symmetric)

\method{SPRDist}{list}(tree1, tree2 = NULL, method = "deOliveira", symmetric)

\method{SPRDist}{multiPhylo}(tree1, tree2 = NULL, method = "deOliveira", symmetric)
}
\arguments{
\item{tree1, tree2}{Trees of class \code{phylo}, with leaves labelled identically,
or lists of such trees to undergo pairwise comparison.  Where implemented,
\code{tree2 = NULL} will compute distances between each pair of trees in the list
\code{tree1} using a fast algorithm based on
\insertCite{Day1985;textual}{TreeDist}.}

\item{method}{Character specifying which method to use to approximate the
SPR distance.  Currently defaults to \code{"deOliveira"}, the only available
option; a new method will eventually become the default.}

\item{symmetric}{Ignored (redundant after fix of
\href{https://github.com/KlausVigo/phangorn/issues/97}{phangorn#97}).}
}
\value{
\code{SPRDist()} returns a vector or distance matrix of distances
between trees.
}
\description{
\code{SPRDist()} calculates an upper bound on the SPR distance between trees
using the heuristic method of \insertCite{deOliveira2008;textual}{TreeDist}.
Other approximations are available
\insertCite{@e.g. @Hickey2008, @Goloboff2008SPR, @Whidden2018}{TreeDist}.
}
\examples{
library("TreeTools", quietly = TRUE)

# Compare single pair of trees
SPRDist(BalancedTree(7), PectinateTree(7))

# Compare all pairs of trees        
SPRDist(as.phylo(30:33, 8))

# Compare each tree in one list with each tree in another
SPRDist(BalancedTree(7), as.phylo(0:2, 7))
SPRDist(as.phylo(0:2, 7), PectinateTree(7))

SPRDist(list(bal = BalancedTree(7), pec = PectinateTree(7)),
        as.phylo(0:2, 7))
}
\references{
\insertAllCited{}
}
\seealso{
Exact calculation with \href{https://ms609.github.io/TBRDist/reference/TreeRearrangementDistances.html}{\pkg{TBRDist}}
functions \code{USPRDist()} and \code{ReplugDist()}.

\pkg{phangorn} function \code{\link[phangorn:treedist]{SPR.dist()}} employs
the \insertCite{deOliveira2008;textual}{TreeDist} algorithm but can crash
when sent trees of certain formats, and tends to have a longer running time.

Other tree distances: 
\code{\link{JaccardRobinsonFoulds}()},
\code{\link{KendallColijn}()},
\code{\link{MASTSize}()},
\code{\link{MatchingSplitDistance}()},
\code{\link{NNIDist}()},
\code{\link{NyeSimilarity}()},
\code{\link{PathDist}()},
\code{\link{Robinson-Foulds}},
\code{\link{TreeDistance}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree distances}
