% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{circleFit}
\alias{circleFit}
\title{Point cloud circle fit}
\usage{
circleFit(las, method = "irls", n = 5, inliers = 0.8, conf = 0.99, n_best = 0)
}
\arguments{
\item{las}{\code{\link[lidR:LAS]{LAS}} object.}

\item{method}{method for estimating the circle parameters. Currently available: \code{"qr"}, \code{"nm"}, \code{"irls"} and \code{"ransac"}.}

\item{n}{\code{numeric} - number of points selected on every RANSAC iteration.}

\item{inliers}{\code{numeric} - expected proportion of inliers among stem segments' point cloud chunks.}

\item{conf}{\code{numeric} - confidence level.}

\item{n_best}{\code{integer} - estimate optimal RANSAC parameters as the median of the \code{n_best} estimations with lowest error.}
}
\value{
vector of parameters
}
\description{
Fits a 2D horizontally-aligned circle on a set of 3D points.
}
