% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{tlsSample}
\alias{tlsSample}
\title{Resample a point cloud}
\usage{
tlsSample(las, method = smp.voxelize())
}
\arguments{
\item{las}{\code{\link[lidR:LAS]{LAS}} object.}

\item{method}{point sampling algorithm. Currently available: \code{\link{smp.voxelize}} and \code{\link{smp.randomize}}}
}
\value{
\code{\link[lidR:LAS]{LAS}} object.
}
\description{
Applies a sampling algorithm to reduce a point cloud's density. Sampling methods are prefixed by \code{smp}.
}
\examples{
file = system.file("extdata", "pine.laz", package="TreeLS")
tls = readTLS(file)
nrow(tls@data)

### sample points systematically from a 3D voxel grid
vx = tlsSample(tls, smp.voxelize(0.05))
nrow(vx@data)

### sample half of the points randomly
rd = tlsSample(tls, smp.randomize(0.5))
nrow(rd@data)

}
