% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_display.R
\name{ConsensusWithout}
\alias{ConsensusWithout}
\alias{MarkMissing}
\title{Consensus without taxa}
\usage{
ConsensusWithout(trees, tip, ...)

MarkMissing(tip, position = "bottomleft", ...)
}
\arguments{
\item{trees}{A list of phylogenetic trees, of class \code{multiPhylo} or \code{list}}

\item{tip}{A character vector specifying the names (or numbers) of tips to
drop (using ape::drop.tip)}

\item{\dots}{Additional parameters to pass on to ape::\link{consensus} or \link{legend}}

\item{position}{Where to plot the missing taxa.  See \link{legend} for options.}
}
\value{
A consensus tree without the excluded taxa
}
\description{
Displays a consensus plot with selected taxa excluded.
}
\details{
A useful way to gain resolution if a few wildcard taxa obscure a consistent
set of relationship.
}
\section{Functions}{
\itemize{
\item \code{MarkMissing}: Adds missing taxa to a plotted consensus tree
}}

\author{
Martin R. Smith

Martin R. Smith
}
