% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpl_morphyex.R
\name{mpl_update_tip}
\alias{mpl_update_tip}
\title{Initial update of tip values following uppass reconstruction.}
\usage{
mpl_update_tip(tip_id, anc_id, morphyobj)
}
\arguments{
\item{tip_id}{The index of the tip being updated.}

\item{anc_id}{The index of the tip's immediate ancestor.}

\item{morphyobj}{An instance of the Morphy object.}
}
\value{
The integral parsimony length (right now)
}
\description{
Ambiguous terminal state sets need to be resolved after the first uppass
based on descendant state values in order for local reoptimisation procedures
to be accurate and for inapplicable step counting to proceed accurately. This
function calls updaters for the records of states active on the subtrees,
thereby allowing the second downpass to accurately reconstruct subtree state
activity.
Because this function needs to be fairly high-performance, it does not do much
checking for parameter validity, thus unsafe usage of this function might not
be caught. It is up to calling functions to ensure that the appropriate
parameters have been set before use.
}
\seealso{
A null value (for now).

Other Morphy API functions: \code{\link{MorphyErrorCheck}},
  \code{\link{MorphyWeights}}, \code{\link{PhyDat2Morphy}},
  \code{\link{SetMorphyWeights}},
  \code{\link{SingleCharMorphy}},
  \code{\link{UnloadMorphy}},
  \code{\link{mpl_apply_tipdata}},
  \code{\link{mpl_attach_rawdata}},
  \code{\link{mpl_attach_symbols}},
  \code{\link{mpl_delete_Morphy}},
  \code{\link{mpl_delete_rawdata}},
  \code{\link{mpl_first_down_recon}},
  \code{\link{mpl_first_up_recon}},
  \code{\link{mpl_get_charac_weight}},
  \code{\link{mpl_get_num_charac}},
  \code{\link{mpl_get_num_internal_nodes}},
  \code{\link{mpl_get_numtaxa}},
  \code{\link{mpl_get_symbols}},
  \code{\link{mpl_init_Morphy}},
  \code{\link{mpl_new_Morphy}},
  \code{\link{mpl_second_down_recon}},
  \code{\link{mpl_second_up_recon}},
  \code{\link{mpl_set_charac_weight}},
  \code{\link{mpl_set_num_internal_nodes}},
  \code{\link{mpl_set_parsim_t}},
  \code{\link{mpl_translate_error}},
  \code{\link{mpl_update_lower_root}},
  \code{\link{summary.morphyPtr}}
}
\author{
Thomas Guillerme
}
\concept{Morphy API functions}
\keyword{internal}
