% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IWScore.R, R/tree_length.R
\name{IWScore}
\alias{IWScore}
\alias{TreeLength}
\alias{TreeLength.phylo}
\alias{TreeLength.numeric}
\alias{TreeLength.list}
\alias{TreeLength.multiPhylo}
\alias{Fitch}
\title{Calculate the parsimony score of a tree given a dataset}
\usage{
IWScore(tree, dataset, concavity = 10L, ...)

TreeLength(tree, dataset, concavity = Inf)

\method{TreeLength}{phylo}(tree, dataset, concavity = Inf)

\method{TreeLength}{numeric}(tree, dataset, concavity = Inf)

\method{TreeLength}{list}(tree, dataset, concavity = Inf)

\method{TreeLength}{multiPhylo}(tree, dataset, concavity = Inf)

Fitch(tree, dataset)
}
\arguments{
\item{tree}{A tree of class \code{phylo}, a list thereof (optionally of class
\code{multiPhylo}), or an integer -- in which case \code{tree} random trees will be
uniformly sampled.}

\item{dataset}{A phylogenetic data matrix of class \code{\link[phangorn]{phyDat}},
whose names correspond to the labels of any accompanying tree.}

\item{concavity}{Determines the degree to which extra steps beyond the first
are penalized.  Specify a numeric value to use implied weighting
\insertCite{Goloboff1993}{TreeSearch}; \code{concavity} specifies \emph{k} in
\emph{k} / \emph{e} + \emph{k}. A value of 10 is recommended;
TNT sets a default of 3, but this is too low in some circumstances
\insertCite{Goloboff2018,Smith2019}{TreeSearch}.
Better still explore the sensitivity of results under a range of
concavity values, e.g. \code{k = 2 ^ (1:7)}.
Specify \code{Inf} to weight each additional step equally.
Specify \code{'profile'} to employ profile parsimony \insertCite{Faith2001}{TreeSearch}.}

\item{\dots}{unused; allows additional parameters specified within \dots to be
received by the function without throwing an error.}
}
\value{
\code{TreeLength()} returns a numeric vector containing the score for
each tree.
}
\description{
\code{TreeLength()} uses the Morphy library \insertCite{Brazeau2017}{TreeSearch}
to calculate a parsimony score for a tree, handling inapplicable data
according to the algorithm of \insertCite{Brazeau2019;textual}{TreeSearch}.
Tree scoring can employ implied weights \insertCite{Goloboff1993}{TreeSearch}
or profile parsimony \insertCite{Faith2001}{TreeSearch}.
}
\examples{
data("inapplicable.datasets")
tree <- TreeTools::BalancedTree(inapplicable.phyData[[1]])
TreeLength(tree, inapplicable.phyData[[1]])
TreeLength(tree, inapplicable.phyData[[1]], concavity = 10)
TreeLength(tree, inapplicable.phyData[[1]], concavity = 'profile')
TreeLength(5, inapplicable.phyData[[1]])
}
\references{
\insertAllCited{}
}
\seealso{
\itemize{
\item Conduct tree search using \code{\link[=MaximizeParsimony]{MaximizeParsimony()}} (command line),
\code{\link[=EasyTrees]{EasyTrees()}} (graphical user interface), or \code{\link[=TreeSearch]{TreeSearch()}}
(custom optimality criteria).
\item See score for each character: \code{\link[=CharacterLength]{CharacterLength()}}.
}

Other tree scoring: 
\code{\link{CharacterLength}()},
\code{\link{MinimumLength}()},
\code{\link{MorphyTreeLength}()}
}
\author{
Martin R. Smith (using Morphy C library, by Martin Brazeau)
}
\concept{tree scoring}
