% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Splits.R
\name{match}
\alias{match}
\alias{match.Splits}
\alias{match.list}
\alias{\%in\%}
\alias{\%in\%.Splits}
\alias{in.Splits}
\title{Split matching}
\usage{
match(x, table, ...)

\method{match}{Splits}(x, table, ...)

\method{match}{list}(x, table, ...)

x \%in\% table

\method{\%in\%}{Splits}(x, table)

in.Splits(x, table)
}
\arguments{
\item{x, table}{Object of class \code{Splits}.}

\item{\dots}{Specify \verb{nomatch =} to provide an integer value that will be
used in place of \code{NA} in the case where no match is found.}
}
\value{
\code{match()} returns an integer vector specifying the position in
\code{table} that matches each element in \code{x}, or \code{nomatch} if no match is found.

\code{\%in\%} returns a logical vector specifying which of the splits in
\code{x} are present in \code{table}.
}
\description{
\code{match()} returns a vector of the positions of (first) matches of splits in
its first argument in its second.
\code{\%in\%} is a more intuitive interface as a binary operator, which returns
a logical vector indicating whether there is a match or not for each
split in its left operand.
}
\details{
\code{in.Splits()} is an alias for \code{\%in\%}, included for backwards compatibility.
It will be deprecated in a future release.
}
\examples{
splits1 <- as.Splits(BalancedTree(7))
splits2 <- as.Splits(PectinateTree(7))

match(splits1, splits2)
splits1 \%in\% splits2

}
\seealso{
Corresponding base functions are documented in
\code{\link[base:match]{match()}}.

Other Splits operations: 
\code{\link{LabelSplits}()},
\code{\link{NSplits}()},
\code{\link{NTip}()},
\code{\link{PolarizeSplits}()},
\code{\link{SplitFrequency}()},
\code{\link{SplitsInBinaryTree}()},
\code{\link{Splits}},
\code{\link{TipLabels}()},
\code{\link{TipsInSplits}()}
}
\concept{Splits operations}
\keyword{methods}
