% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SplitFunctions.R
\name{CompatibleSplits}
\alias{CompatibleSplits}
\alias{.CompatibleSplit}
\alias{.CompatibleRaws}
\title{Which splits are compatible?}
\usage{
CompatibleSplits(splits, splits2)

.CompatibleSplit(a, b, nTip)

.CompatibleRaws(rawA, rawB, bitmask)
}
\arguments{
\item{splits}{An object of class \code{\link[=as.Splits]{Splits}}.}

\item{splits2}{A second \code{Splits} object.}

\item{a, b}{\link[=raw]{Raw} representations of splits, from a row of a \code{Splits}
object.}

\item{rawA, rawB}{Raw representations of splits.}

\item{bitmask}{Raw masking bits that do not correspond to tips.}
}
\value{
\code{CompatibleSplits} returns a logical matrix specifying whether each
split in \code{splits} is compatible with each split in \code{splits2}.

\code{.CompatibleSplit} returns a logical vector stating whether splits
are compatible.

\code{.CompatibleRaws} returns a logical vector specifying whether input
raws are compatible.
}
\description{
Which splits are compatible?
}
\examples{
splits <- as.Splits(BalancedTree(8))
splits2 <- as.Splits(PectinateTree(8))

summary(splits)
summary(splits2)

CompatibleSplits(splits, splits2)

}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\keyword{internal}
