% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biophysmodel_LizardFei.R
\name{Tb_lizard_Fei}
\alias{Tb_lizard_Fei}
\title{Operative Temperature of a Lizard Using Fei et al. (2012)}
\usage{
Tb_lizard_Fei(T_a, T_g, H, lw, shade, m, Acondfact, Agradfact)
}
\arguments{
\item{T_a}{\code{numeric} air temperature at lizard height (K).}

\item{T_g}{\code{numeric} surface temperature (K).}

\item{H}{\code{numeric} total (direct + diffuse) solar radiation flux (\ifelse{html}{\out{W m<sup>-2</sup>}}{\eqn{W m-^2}{ASCII}}).}

\item{lw}{\code{numeric} downward flux of near-infrared radiation (\ifelse{html}{\out{W m<sup>-2</sup>}}{\eqn{W m-^2}{ASCII}}).}

\item{shade}{\code{numeric} proportion of shade.}

\item{m}{\code{numeric} lizard mass (g).}

\item{Acondfact}{\code{numeric} proportion of the lizard projected area that is in contact with the ground. \code{Acondfact = 0.1} for standing and \code{Acondfact = 0.4} for lying on ground.}

\item{Agradfact}{\code{numeric} proportion of the lizard projected area exposed to radiation from the ground. \code{Agradfact = 0.3} for standing and \code{Agradfact = 0.0} for lying on ground.}
}
\value{
\code{numeric} predicted body (operative environmental) temperature (K).
}
\description{
The function predicts body temperature (K, operative environmental temperature) of a lizard based on \insertCite{Fei2012;textual}{TrenchR}.
}
\details{
Thermal radiative flux is calculated following \insertCite{Fei2012;textual}{TrenchR} based on \insertCite{Bartlett1967;textual}{TrenchR} and \insertCite{Porter1973;textual}{TrenchR}.
}
\examples{
  Tb_lizard_Fei(T_a       = 293,
                T_g       = 300,
                H         = 1300, 
                lw        = 60, 
                shade     = 0.5, 
                m         = 10.5, 
                Acondfact = 0.1, 
                Agradfact = 0.3)


}
\references{
\insertAllCited{}
}
\seealso{
Other biophysical models: 
\code{\link{Grashof_number_Gates}()},
\code{\link{Grashof_number}()},
\code{\link{Nusselt_from_Grashof}()},
\code{\link{Nusselt_from_Reynolds}()},
\code{\link{Nusselt_number}()},
\code{\link{Prandtl_number}()},
\code{\link{Qconduction_animal}()},
\code{\link{Qconduction_substrate}()},
\code{\link{Qconvection}()},
\code{\link{Qemitted_thermal_radiation}()},
\code{\link{Qevaporation}()},
\code{\link{Qmetabolism_from_mass_temp}()},
\code{\link{Qmetabolism_from_mass}()},
\code{\link{Qnet_Gates}()},
\code{\link{Qradiation_absorbed}()},
\code{\link{Qthermal_radiation_absorbed}()},
\code{\link{Reynolds_number}()},
\code{\link{Tb_CampbellNorman}()},
\code{\link{Tb_Gates2}()},
\code{\link{Tb_Gates}()},
\code{\link{Tb_butterfly}()},
\code{\link{Tb_grasshopper}()},
\code{\link{Tb_limpetBH}()},
\code{\link{Tb_limpet}()},
\code{\link{Tb_lizard}()},
\code{\link{Tb_mussel}()},
\code{\link{Tb_salamander_humid}()},
\code{\link{Tb_snail}()},
\code{\link{Tbed_mussel}()},
\code{\link{Tsoil}()},
\code{\link{actual_vapor_pressure}()},
\code{\link{boundary_layer_resistance}()},
\code{\link{external_resistance_to_water_vapor_transfer}()},
\code{\link{free_or_forced_convection}()},
\code{\link{heat_transfer_coefficient_approximation}()},
\code{\link{heat_transfer_coefficient_simple}()},
\code{\link{heat_transfer_coefficient}()},
\code{\link{saturation_vapor_pressure}()},
\code{\link{saturation_water_vapor_pressure}()}
}
\author{
Ofir Levy
}
\concept{biophysical models}
