% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_tweets.R
\name{load_tweets}
\alias{load_tweets}
\title{Converts Twitter stream data (JSON file) into parsed data frame}
\usage{
load_tweets(file_name)
}
\arguments{
\item{file_name}{Character string. Name of JSON file with data collected by
\link[rtweet]{stream_tweets} or \code{get_tweets()}.}
}
\value{
A data frame of tweets data with additional meta data
}
\description{
Parse JSON files of collected Tweets
}
\details{
This function replaces \link[rtweet]{parse_stream} which has been
deprecated in rtweet 0.7 but is included here to ensure backwards compatibility
for data streamed with older versions of \code{rtweet}.
Alternatively \link[jsonlite]{stream_in} in conjunction with \link[rtweet]{tweets_with_users}
and \link[rtweet]{lat_lng} can be used if data has been collected with rtweet 0.7 or newer.
}
\examples{

\dontrun{

library(Twitmo)

# load tweets (included in package)
raw_path <- system.file("extdata", "tweets_20191027-141233.json", package = "Twitmo")
mytweets <- load_tweets(raw_path)
}
}
\seealso{
\link[rtweet]{parse_stream}, \link[jsonlite]{stream_in}, \link[rtweet]{tweets_with_users}
}
