% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_2rm_helpers.R
\name{DualCP_LOSO}
\alias{DualCP_LOSO}
\alias{fold}
\alias{get_cv_predictions}
\alias{get_fold_model}
\alias{get_classifications}
\title{Perform leave-one-participant-out-cross-validation on a two-regression
algorithm}
\usage{
DualCP_LOSO(
  subject_var = "id",
  data,
  model,
  MET_var = "MET_RMR",
  activity_var = "Behavior",
  verbose = FALSE,
  trace = FALSE
)

fold(x, subject_var, data, model, MET_var, activity_var, trace)

get_cv_predictions(model, fold_data, cv_data)

get_fold_model(formula_string, fold_data, level = c("walkrun", "intermittent"))

get_classifications(
  data,
  model,
  numeric = TRUE,
  labels = c("SB", "walkrun", "intermittent")
)
}
\arguments{
\item{subject_var}{character. Variable name that distinguishes between
participants}

\item{data}{the full data set to cross-validate}

\item{model}{a \code{TwoRegression} object formed with \code{\link{fit_2rm}}
on which to perform the cross-validation}

\item{MET_var}{character. The outcome variable name (in metabolic equivalents)}

\item{activity_var}{character. The variable name for the activity being
performed}

\item{verbose}{logical. Print updates?}

\item{trace}{logical. Print information about each iteration?}

\item{x}{character. The id to hold out}

\item{fold_data}{the validation data set}

\item{cv_data}{the holdout (i.e., cross-validation) data set}

\item{formula_string}{character. Formula to apply in call to \code{lm}}

\item{level}{character. Classification subset to include in call to \code{lm}}
}
\value{
A data frame with predictions obtained from
  leave-one-participant-out-cross-validation
}
\description{
Perform leave-one-participant-out-cross-validation on a two-regression
algorithm
}
\note{
This function will not work for \code{TwoRegression} objects formed
  from previously-published research. The \code{TwoRegression} object needs
  to have more information than is available in those cases in order to
  perform cross-validation, and this is sensible, since there is no reason or
  way to re-perform cross-validation on an already-finalized algorithm.
}
\keyword{internal}
