% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{Zdists}
\alias{Zdists}
\title{Zdist Goodness of fit measure for pooling groups}
\usage{
Zdists(x)
}
\arguments{
\item{x}{pooling group derived from the Pool() function}
}
\value{
A list with the first element a data.frame of four Z-Scores related to the columns; "GEV", "GenLog", "Gumbel", and "Kappa3". The second element is a character stating which has the best fit.
}
\description{
Calculates the goodness of fit score for pooling groups.
}
\details{
The goodness of fit measure provides a Z-Score which quantifies the number of standard deviations from the mean of a normal distribution. To determine goodness of fit for a given distribution (assume GEV for this example), 500 pooling groups are formed which match the number of sites and samples sizes of the pooling group of interest. These are formed by simulation with the GEV distribution having LCV and LSKEW which are the weighted mean LCV and LSKEW of the pooling group (weighted by sample size) and a median of 1. The weighted mean L-Kurtosis of the observed pooling group (tR4) is compared to the mean and standard deviation (sd) of L-Kurtosis from the simulated pooling groups (tR4_Dist) by calculating the associated Z-score: (tR4 – mean(tR4_Dist)) / sd(tR4_Dist). The fit of the distribution can be considered acceptable if the absolute Z-Score is less than 1.645 (essentially a hypothesis test with alpha level equal to 0.1). This is done for all candidate distributions and the lowest absolute score is considered the best fit.
}
\examples{
#Get CDs, form a pooling group and calculate the Zdist
CDs.203018 <- GetCDs(203018)
Pool.203018 <- Pool(CDs.203018)
Zdists(Pool.203018)
}
\author{
Anthony Hammond
}
