% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{NGRDist}
\alias{NGRDist}
\title{British national grid reference (NGR) distances}
\usage{
NGRDist(i, j)
}
\arguments{
\item{i}{a numeric vector of length two. The first being the easting and the second being the northing of the first site}

\item{j}{a numeric vector of length two. The first being the easting and the second being the northing of the second site}
}
\value{
A distance in kilometres (if six digits for easting and northing are used)
}
\description{
Calculates the euclidean distance between two british national grid reference points using the pythagorean method
}
\details{
Note, that the result is converted to km when six digits are used for easting and northing, when six digits would usually provide a result in metres.
}
\examples{
#Calculate the distance between the catchment centroid for the
#Kingston upon Thames river gauge and the catchment centroid for the
#gauge at Ardlethen on the River Ythan. First view the eastings and northings
GetCDs(10001)
GetCDs(39001)
NGRDist(i = c(381355, 839183), j = c(462899, 187850))
}
\author{
Anthony Hammond
}
