% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{bt.coef}
\alias{bt.coef}
\title{Back-Transformation of Estimated Coefficients.}
\usage{
bt.coef(object, K = NULL, signJ = NULL, model = NULL, ...)
}
\arguments{
\item{object}{(object) of class 'gnm' representing a fitted model in re-parameterized form}

\item{K}{(numeric) constant value 'K'}

\item{signJ}{(integer) either 1 or -1}

\item{model}{(integer) specifying which model shall be back-transformed}

\item{...}{additional parameters}
}
\value{
(numeric) vector of coefficients in original parameterized form
}
\description{
This function performs back-transformation from re-parameterized forms in the 'VFP'-package
into the original form.
}
\details{
In the 'VFP' package models are re-parameterized to have better control over the constraint
solution-space, i.e. only models may be fitted generating non-negative fitted values. This 
function is intended to be for internal use only.
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
			Florian Dufey \email{florian.dufey@roche.com}
}
