% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{evaluation}
\alias{evaluation}
\alias{nrmse}
\alias{pfc}
\alias{msecov}
\alias{msecor}
\alias{mape}
\alias{lr}
\alias{smape}
\title{Error performance measures}
\usage{
evaluation(x, y, m, vartypes = "guess")

nrmse(x, y, m)

pfc(x, y, m)

mape(x, y, m)

lr(x, y, m)

smape(x, y, m)

msecov(x, y)

msecor(x, y)
}
\arguments{
\item{x}{matrix or data frame}

\item{y}{matrix or data frame of the same size as x}

\item{m}{the indicator matrix for missing cells}

\item{vartypes}{a vector of length ncol(x) specifying the variables types, like factor or numeric}
}
\value{
the error measures value
}
\description{
Various error measures evaluating the quality of imputations
}
\details{
This function has been mainly written for procudures 
that evaluate imputation or replacement of rounded zeros. The ni parameter can thus, e.g. be
used for expressing the number of rounded zeros.
}
\examples{
data(iris)
iris_orig <- iris_imp <- iris
iris_imp$Sepal.Length[sample(1:nrow(iris), 10)] <- NA
iris_imp$Sepal.Width[sample(1:nrow(iris), 10)] <- NA
iris_imp$Species[sample(1:nrow(iris), 10)] <- NA
m <- is.na(iris_imp)
iris_imp <- VIM::kNN(iris_imp, imp_var = FALSE)
\dontrun{
evaluation(iris_orig, iris_imp, m = m, vartypes = c(rep("numeric", 4), "factor"))
msecov(iris_orig[, 1:4], iris_imp[, 1:4])
}
}
\references{
M. Templ, A. Kowarik, P. Filzmoser (2011) Iterative stepwise
regression imputation using standard and robust methods.  \emph{Journal of
Computational Statistics and Data Analysis}, Vol. 55, pp. 2793-2806.
}
\author{
Matthias Templ
}
\keyword{manip}
