% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svm_code.R
\name{plotperf}
\alias{plotperf}
\title{Performance plots for the approximation of an SVM model.}
\usage{
plotperf(mymodel, mydata, indy, mytestdata, type = "all", filename)
}
\arguments{
\item{mymodel}{Element of class \code{ksvm}.}

\item{mydata}{Data on which \code{mymodel} was trained on.}

\item{indy}{Column number of the outcome in \code{mydata}.}

\item{mytestdata}{Data on which to evaluate \code{mymodel}.  (Optional)}

\item{type}{Type of performance plot (c="all","lp","probs","outcomes","contributions",
"ROC","corrplot").  See details for more information.}

\item{filename}{Name of the resulting graph.}
}
\description{
Generate performance plots for the approximation of an SVM model.
}
\details{
Different types of plots are possible.  When \code{type}="all", all the options are generated.  When \code{type}="lp", 
the latent variables of the approximation and the original SVM model are plotted against eachother.  When \code{type}="probs"
the estimated probabilities of the approximation and the SVM model are plotted against eachother.  When \code{type}="outcomes" a bubble 
plot indicating the agreement between the approximation and the SVM model is generated.  When \code{type}="contributions", the range of
the contributions within the approximation, the range of the rest term and the range of the latent variable of the SVM model are represented
by means of boxplots.  All of these are shifted to have a median equal to zero. When \code{type}="ROC", ROC curves for the approximation and 
the SVM model are plotted.  When mytestdata is non-empty, ROC curves for the test set are also provided.
}
\examples{
#### Support Vector Machine classifier
library(kernlab)
data(iris)
levels(iris$Species)[levels(iris$Species)=="setosa"] <- "other"
levels(iris$Species)[levels(iris$Species)=="virginica"] <- "other"
names(iris)=c("SL","SW","PL","PW","Species")
# good model
model <-ksvm(Species ~ ., data = iris,prob.model=TRUE,kpar=list(0.03),C=10)
# bad model
model2 <-ksvm(Species ~ ., data = iris,prob.model=TRUE,kpar=list(10),C=10)
# plot latent variables of approximation and SVM
plotperf(model,iris,indy=5,type="lp",filename="iris")
plotperf(model2,iris,indy=5,type="lp",filename="iris2")
# plot contributions of approximation and SVM
# good model: rest term is small in comparison with other contributions and lpmodel 
# (latent variable of SVM)
plotperf(model,iris,indy=5,type="contributions",filename="iris") 
# bad model: rest term is large in comparison with other contributions and lpmodel 
# (latent variable of SVM)
plotperf(model2,iris,indy=5,type="contributions",filename="iris2")
# plot latent variables of approximation and SVM
plotperf(model,iris,indy=5,type="outcomes",filename="iris")
plotperf(model2,iris,indy=5,type="outcomes",filename="iris2")
}
\author{
Vanya Van Belle
}
\references{
Van Belle V., Van Calster B., Suykens J.A.K., Van Huffel S. and Lisboa P., \emph{Explaining support vector machines: a color based nomogram}, Internal Report 16-27, ESAT-Stadius, KU Leuven (Leuven, Belgium), 2016
}

