% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vertTFCE.R
\name{TFCE_threshold}
\alias{TFCE_threshold}
\title{Thresholding TFCE output}
\usage{
TFCE_threshold(TFCEoutput, p = 0.05, atlas = 1, k = 20, VWR_check = TRUE)
}
\arguments{
\item{TFCEoutput}{An object containing the output from TFCE_vertex_analysis()}

\item{p}{A numeric object specifying the p-value to threshold the results (Default is 0.05)}

\item{atlas}{A numeric integer object corresponding to the atlas of interest. 1=Desikan, 2=Schaefer-100, 3=Schaefer-200, 4=Glasser-360, 5=Destrieux-148 (Default is 1)}

\item{k}{Cluster-forming threshold (Default is 20)}

\item{VWR_check}{A boolean object specifying whether to check and validate system requirements. Default is TRUE.}
}
\value{
A list object containing the cluster level results, thresholded t-stat map, and positive, negative and bidirectional cluster maps.
}
\description{
Threshold TFCE maps from the TFCE_vertex_analysis() output and identifies significant clusters at the desired threshold.
}
\examples{
model1_TFCE=readRDS(system.file('demo_data/model1_TFCE.rds', 
package = 'VertexWiseR'))

TFCEanalysis_output=TFCE_threshold(model1_TFCE, p=0.05, atlas=1,
VWR_check=FALSE)
TFCEanalysis_output$cluster_level_results
}
