% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fibonacci.R
\name{23. Fibonacci numbers}
\alias{23. Fibonacci numbers}
\alias{Fibonacci}
\alias{Fibonacci.default}
\alias{Fibonacci.numeric}
\alias{nthFibonacci}
\alias{nthFibonacci.default}
\alias{nthFibonacci.numeric}
\alias{nthFibonacci.vli}
\alias{is.Fibonacci}
\alias{is.Fibonacci.default}
\alias{is.Fibonacci.numeric}
\alias{is.Fibonacci.vli}
\title{Fibonacci Numbers Tools for vli Objects}
\usage{
Fibonacci(m, output = "print")

\method{Fibonacci}{default}(m, output = "print")

\method{Fibonacci}{numeric}(m, output = "print")

nthFibonacci(n)

\method{nthFibonacci}{default}(n)

\method{nthFibonacci}{numeric}(n)

\method{nthFibonacci}{vli}(n)

is.Fibonacci(x)

\method{is.Fibonacci}{default}(x)

\method{is.Fibonacci}{numeric}(x)

\method{is.Fibonacci}{vli}(x)
}
\arguments{
\item{m}{object of class vli or 32 bits integer}

\item{output}{chosen way for objects being returned: \code{'list'} to return the result as a list of vli objects or \code{'print'} (by default) to simply display the result on the screen; character}

\item{n}{vli class object or 32 bits integer}

\item{x}{vli class object or 32 bits integer}
}
\value{
The function \code{Fibonacci(m, output)} returns a list of objects of class vli or the result displayed on the screen, depending on the \code{output} argument.

The function \code{nthFibonacci(n)} returns a object of class vli.

The function \code{is.Fibonacci(x)} returns a boolean.
}
\description{
The Fibonacci Sequence is defined as follows:

\code{x[1] = 0},

\code{x[2] = 1},

\code{...}

\code{x[n] = x[n-1] + x[n-2]}.

A positive integer is said to be a Fibonacci Number if it is an element of the Fibonacci Sequence.

The function \code{Fibonacci(m, output)} computes and displays the first \code{m} elements of the Fibonacci Sequence.

The function \code{nthFibonacci(n)} computes and displays the \code{n}-th element of the Fibonacci Sequence.

The function \code{is.Fibonacci(x)} says whether or not \code{x} is a Fibonacci Number.
}
\examples{
Fibonacci(200)

n <- as.vli("50000")
nthFibonacci(n)

x <- as.vli("5358359254990966640871840")
is.Fibonacci(x)

y <- x + 1
is.Fibonacci(y)
}
\author{
Javier Leiva Cuadrado
}
