% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ViSibook.r
\docType{package}
\name{ViSiElse}
\alias{ViSiElse}
\alias{ViSiElse-package}
\title{ViSiElse: A visual tool for behaviour analysis}
\description{
VisiElse is \strong{a graphical tool} designed to visualize and to \strong{give an overview of behavioural observations}
realized on individuals or groups. For example, ViSiElse allows \strong{visualization of raw data}
during experimental observations of the \strong{realization of a procedure} like a medical algorithm.
It graphically presents an overview of individuals and group \strong{actions usually acquired from timestamps 
during video recorded sessions}. Options of the package allow adding graphical information 
as statistical indicators (mean, standard deviation, quantiles or statistical tests) but also for
each action green or black zones providing visual information about the accuracy of the realized actions.
}
\section{Principal}{

ViSiElse concerns \strong{behavioural processes} that, like a simulated healthcare procedure, 
can be \strong{decomposed in actions}. We define two different types of actions in ViSiElse: 
\strong{punctual and long}. The actions called punctual are brief actions defined as a \strong{time points}. 
They \strong{does not last enough to be measured on the chosen time scale}. The actions called long are the 
ones defined by \strong{duration}. They are characterized by both \strong{a beginning punctual action and an
 ending one}. In order to \strong{model a procedure}, there is a need to sort actions in the way they 
 are supposed to be realized as defined for example by medical consensus and/or algorithms for a 
 medical procedure. This \strong{structure is stored in a S4-class object ViSibook}, it can be modified, 
 printed or plotted.
}

\section{S4-methods}{

This Package contains two S4class of object: \code{\linkS4class{ViSibook}} and ViSigrid. 
Basically a \code{\linkS4class{ViSibook}} object will store information on a process 
like a health care procedure, then a \code{\linkS4class{ViSigrid}} object is built with 
observations of this procedure and the procedure \code{\linkS4class{ViSibook}}, and finally the graphic 
is optained by plotting this \code{\linkS4class{ViSigrid}} object.
}

\section{ViSibook-class}{

The \strong{minimum stucture} for a ViSibook must give for each action its name (without special characters but"_"), 
its label, and its type (punctual or long). For a long action, in addition it is necessary to provide the two specific
 actions that defined its starting and ending.
The \strong{order} by which actions are supposed to happen is also required. It is possible to not attribute a rank order at
some actions, but not all. 
This is useful in the case of a procedure focuses on a long action but 
does not on punctual actions defining its end or beginning thus those two punctual actions can
 have an order not set.


Beyond the minimum structure green zones or/and black zones can be defined to help to visualize if a behaviour 
is realized on time.
Black zones can be defined on both punctual and long action but green zones can only be defined
 on punctual actions. To get the details see
the definition of the class \code{\linkS4class{ViSibook}}.
}

\section{ViSiGrid-class}{

A ViSigrid object is built using the function \code{ \link{buildViSiGrid}} with at least : \itemize{
\item{The procedure structure}{: It is stored in a ViSibook object.}
\item{Observations}{ : Dataset which stores individuals realisation times for each punctal action.}
}
Options can be add like group, indicator,... see \code{ \link{buildViSiGrid}} and \code{\linkS4class{ViSigrid}} 
to get more details explanations.


At the end the plot of a \code{ViSigrid} object provides a graphics of the realisation of a process.
}

